//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.4

Item {
    id : delegateItem

    property int        idx             : index
    property alias      mouseArea       : mouseArea
    property alias      hoverEnabled    : mouseArea.hoverEnabled
    property alias      acceptedButtons : mouseArea.acceptedButtons
    property ListView   listView : {
         //! Delegate can only be used in a SelectionListView
        if (ListView && ListView.view) {
            return ListView.view;
        }
       throw new Error("Failed to obtain the containing view");
    }

    MouseArea {
        id : mouseArea

        anchors.fill : parent

        Keys.forwardTo :  listView
        acceptedButtons : Qt.LeftButton | Qt.RightButton
        onPressed : {
            listView.forceActiveFocus();

            if (mouse.modifiers !== Qt.NoModifier)
                return; // otherwise adding selection with ctrl won't work

            if (listView.selection.length === 0
                    || listView.selection.indexOf(document) === -1) {
                listView.selection = [document];
            }
        }

        onClicked : {
            var oldIndex  = listView.currentIndex;
            listView.currentIndex = delegateItem.idx;

            if (mouse.button === Qt.LeftButton) {
                if ((mouse.modifiers === Qt.NoModifier)
                        || !listView.multiSelection) {
                    listView.previousIndex = listView.currentIndex;
                    listView.selection = [document];
                    return;
                }

                // Shift + Ctrl selection handling
                if (mouse.modifiers === Qt.ControlModifier){
                    listView.previousIndex = listView.currentIndex;

                    var idx = listView.selection.indexOf(document);
                    if (idx !== -1) {
                        var selection = listView.selection;
                        selection.splice(idx, 1);
                        listView.selection = selection;
                    } else {
                        listView.selection = [document].concat(
                                    listView.selection);
                    }
                } else if (mouse.modifiers ===
                           (Qt.ShiftModifier | Qt.ControlModifier)) {
                    listView.previousIndex = oldIndex;

                    listView.selection = listView.selection.concat(
                                listView.selectRange(listView.previousIndex,
                                                     listView.currentIndex,
                                                     false));
                }  else if (mouse.modifiers === Qt.ShiftModifier) {
                    if (listView.previousIndex === -1)
                        listView.previousIndex = oldIndex;

                    listView.selection = listView.selectRange(
                                listView.previousIndex, listView.currentIndex);
                }
            }

            if (mouse.button === Qt.RightButton) {
                // only handle single right click select if not part of selection
                if (listView.selection.indexOf(document) === -1) {
                    listView.previousIndex = -1;
                    listView.currentIndex = delegateItem.idx;
                    listView.selection = [document];
                }
            }
        }
    } // mouseArea
}

